﻿Partial Public Class MainPage
    Inherits PhoneApplicationPage

    Public Sub New()
        InitializeComponent()
    End Sub


    Private Sub OnButtonClick(ByVal sender As Object, ByVal args As RoutedEventArgs)
        Dim btn = TryCast(sender, Button)
        stackPanel.Children.Clear()
        DumpVisualTree(btn, 0)
    End Sub


    Private Sub DumpVisualTree(ByVal parent As DependencyObject, ByVal indent As Integer)
        Dim txtblk As New TextBlock()
        txtblk.Text = String.Format("{0}{1}",
                                    New String(" "c, 4 * indent),
                                    parent.GetType().Name)
        stackPanel.Children.Add(txtblk)

        Dim numChildren = VisualTreeHelper.GetChildrenCount(parent)

        For childIndex = 0 To numChildren - 1
            Dim child = VisualTreeHelper.GetChild(parent, childIndex)
            DumpVisualTree(child, indent + 1)
        Next childIndex
    End Sub
End Class
